#!/bin/sh
MYDIR="$( /usr/bin/dirname $0 )"
FORM_PATH="$( /bin/realpath ${MYDIR} )"
HELPER="jrctl"

: ${distdir="/usr/local/cbsd"}
# MAIN
if [ -z "${workdir}" ]; then
	[ -z "${cbsd_workdir}" ] && . /etc/rc.conf
	[ -z "${cbsd_workdir}" ] && exit 0
	workdir="${cbsd_workdir}"
fi

set -e
. ${distdir}/cbsd.conf
. ${subrdir}/tools.subr
. ${subrdir}/nc.subr
set +e

FORM_PATH="${workdir}/formfile"

[ ! -d "${FORM_PATH}" ] && err 1 "No such ${FORM_PATH}"
[ -f "${FORM_PATH}/${HELPER}.sqlite" ] && /bin/rm -f "${FORM_PATH}/${HELPER}.sqlite"

/usr/local/bin/cbsd ${miscdir}/updatesql ${FORM_PATH}/${HELPER}.sqlite /usr/local/cbsd/share/forms.schema forms
/usr/local/bin/cbsd ${miscdir}/updatesql ${FORM_PATH}/${HELPER}.sqlite /usr/local/cbsd/share/forms_system.schema system

${SQLITE3_CMD} ${FORM_PATH}/${HELPER}.sqlite << EOF
BEGIN TRANSACTION;
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,1,'-','RACCT limits','-','','',1, 'maxlen=128', 'delimer', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,2,'cputime','CPU time, in seconds; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,3,'datasize','data size, in bytes or ^m ^g suffix; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,4,'stacksize','stack size, in bytes or ^m ^g suffix; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,5,'coredumpsize','core dump size, in bytes or ^m ^g suffix; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,6,'memoryuse','resident set size, in bytes or ^m ^g suffix; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,7,'memorylocked','locked memory, in bytes or ^m ^g suffix; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,8,'maxproc','number of processes; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,9,'openfiles','file descriptor table size; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,10,'vmemoryuse','address space limit, in bytes or ^m ^g suffix; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,11,'pseudoterminals','number of PTYs; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,12,'swapuse','swap usage, in bytes or ^m ^g suffix; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,13,'nthr','number of threads; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,14,'msgqqueued','number of queued SysV messages; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,15,'msgqsize','SysV message queue size, in bytes or ^m ^g suffix; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,16,'nmsgq','number of SysV message queues; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,17,'nsem','number of SysV semaphores; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,18,'nsemop','number of SysV semaphores modified in a single semop(2) call; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,19,'nshm','number of SysV shared memory segments; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,20,'shmsize','SysV shared memory size, in bytes or ^m ^g suffix; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,21,'wallclock','wallclock time, in seconds; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,22,'pcpu','%CPU, in percents of a single CPU core; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,23,'readbps','filesystem reads, in bytes per second; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,24,'writebps','filesystem writes, in bytes per second; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,25,'readiops','filesystem reads, in operations per second; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,26,'writeiops','filesystem writes, in operations per second; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );

INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,100,'-','ZFS limits','-','','',1, 'maxlen=128', 'delimer', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,101,'fsquota','Limit jail filesystem, in ^m ^g suffix; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );

INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,200,'-','Other limits','-','','',1, 'maxlen=128', 'delimer', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,201,'nice','Priority for nice: from -20 (higher pri) to 20 (lower pri); default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,202,'bw','Network traffic bandwitch limit; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
INSERT INTO forms ( mytable,group_id,order_id,param,desc,def,cur,new,mandatory,attr,type,link,groupname ) VALUES ( 'forms', 1,203,'cpu','CPU limit, in cores; default is: 0','0','','',1, 'maxlen=60', 'inputbox', '', '' );
COMMIT;
EOF

${SQLITE3_CMD} ${FORM_PATH}/${HELPER}.sqlite << EOF
BEGIN TRANSACTION;
INSERT INTO system ( helpername, version, packages, have_restart ) VALUES ( '${HELPER}', '201607', '', '' );
COMMIT;
EOF

# long description
${SQLITE3_CMD} ${FORM_PATH}/${HELPER}.sqlite << EOF
BEGIN TRANSACTION;
UPDATE system SET longdesc='\
Jail resource limit control module \
';
COMMIT;
EOF
